﻿uses GraphWPF, Timers, MathExtensions;

var
  currentSize: int;
  cellSize: int;
  showNumbers: bool := true;
  // 0 - синий, 1 - радуга, 2 - тепловая карта
  colorMode: int := 0; 


// ВОЗВРАЩАЕТ ЦВЕТ КЛЕТОК
function GetPrimeColor(n: integer): Color;
begin
   case colorMode of
        0: Result := Colors.Blue;
        1: Result := Color.FromRgb(Random(256), Random(256), Random(256));
        // тпловая карта: чем больше n, тем "теплее" цвет
        2: begin
              var intensity := Min(255, n div 10);
              Result := Color.FromRgb(255, 255 - intensity, 255 - intensity);
           end;
    else Result := Colors.Blue;
  end;
end;


// ЧЕРТИТ СПИРАЛЬ УЛАМА
procedure DrawUlamSpiral(size: integer);
begin
   currentSize := size;
   cellSize := Round(Min(Window.Width, Window.Height) / size) - 2;
  
   Window.Clear(Colors.White);
   Window.Title := $' Спираль Улама {size} × {size} (цвет: ' + 
                  if colorMode = 0 then 'синий)' else if colorMode = 1 then 'радуга)' else 'тепло)';
  
   var spiral := new integer[size, size];
   var x := size div 2;
   var y := size div 2;
   var num := 1;
  
   // заполняем спираль:
   var dirs := Arr((0,1), (1,0), (0,-1), (-1,0));
   var dirIdx := 0;
   var steps := 1;
  
   while num <= size*size do begin
      spiral[x, y] := num;
    
      for var i := 1 to 2 do begin
          var (dx, dy) := dirs[dirIdx];
          for var j := 1 to steps do begin
              x += dx;
              y += dy;
              num += 1;
             if num <= size*size then
                spiral[x, y] := num;
          end;
          dirIdx := (dirIdx + 1) mod 4;
       end;
       steps += 1;
    end;
  
   // рисуем спираль:
   var offsetX := (Window.Width - size * cellSize) / 2;
   var offsetY := (Window.Height - size * cellSize) / 2;
  
   for var i := 0 to size - 1 do
       for var j := 0 to size - 1 do begin
           var cellX := offsetX + j * cellSize;
           var cellY := offsetY + i * cellSize;
           var number := spiral[i, j];
      
           // рисуем клетку:
           Pen.Color := Colors.LightGray;
           Brush.Color := Colors.White;
           Rectangle(cellX, cellY, cellSize, cellSize);
      
           // закрашиваем простые числа:
           if number.IsPrime then begin
              Brush.Color := GetPrimeColor(number);
              FillRectangle(cellX + 1, cellY + 1, cellSize - 2, cellSize - 2);
           end;
      
          // печатаем число:
          if showNumbers and (cellSize > 15) then begin
             Brush.Color := Colors.Transparent;
             Font.Size := Max(6, cellSize div 3);
             var textColor := if number.IsPrime then Colors.White else Colors.Black;
             DrawText(cellX + 2, cellY + 2, cellSize - 4, cellSize - 4, 
                      number, textColor);
      end;
    end;
  
   // считаем простые числа:
   var primeCount := 0;
   for var i := 0 to size - 1 do
       for var j := 0 to size - 1 do
           if spiral[i, j].IsPrime then
              primeCount += 1;
  
   // надписи:
   Brush.Color := Colors.Transparent;
   Font.Size := 14;
   TextOut(10, 0, $' Спираль Улама {size} × {size}');
   Font.Size := 12;
  
   TextOut(10, 22, $' Простых чисел: {primeCount} ({Round((primeCount * 100 / (size*size)), 2)}%)');
   TextOut(10, Window.Height - 30, 'Управление: 1-4 размер, C - цвета, N - числа, Esc - выход');
end;


procedure KeyDown(k: Key);
begin
   case k of
        Key.D1: begin
                Window.SetSize(500, 500); DrawUlamSpiral(21); end;
        Key.D2: begin 
                Window.SetSize(600, 600); DrawUlamSpiral(31); end;
        Key.D3: begin 
                Window.SetSize(700, 700); DrawUlamSpiral(41); end;
        Key.D4: begin 
                Window.SetSize(800, 800); DrawUlamSpiral(51); end;
        Key.D5: begin 
                Window.SetSize(1000, 960); DrawUlamSpiral(71); end;
        Key.C: begin 
               colorMode := (colorMode + 1) mod 3;
               DrawUlamSpiral(currentSize); end;
        Key.N: begin 
               showNumbers := not showNumbers;
               DrawUlamSpiral(currentSize); end;
        Key.Escape: Window.Close;
   end;
end;


begin
   Window.SetSize(700, 700);
   Window.CenterOnScreen;
  
   // начальная спираль:
   DrawUlamSpiral(41);
  
   // обработчик нажатия на клавиши:
   OnKeyDown := KeyDown;
  
   // инструкция в консоли:
   Writeln(' Управление:');
   Writeln(' 1 - спираль 21×21');
   Writeln(' 2 - спираль 31×31');
   Writeln(' 3 - спираль 41×41');
   Writeln(' 4 - спираль 51×51');
   Writeln(' 5 - спираль 71×71');
   Writeln(' C - переключение цветовой схемы');
   Writeln(' N - показать/скрыть числа');
   Writeln(' Esc - выход');
end.